/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.util.exceptions.RegistryFailureException;
import com.momosoftworks.coldsweat.util.math.FastBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class TempModifierRegistry {
    static FastBiMap<ResourceLocation, TempModifierHolder> TEMP_MODIFIERS = new FastBiMap();

    public static BiMap<ResourceLocation, TempModifierHolder> getEntries() {
        return ImmutableBiMap.copyOf(TEMP_MODIFIERS);
    }

    public static void register(ResourceLocation id, Supplier<TempModifier> supplier) {
        if (TEMP_MODIFIERS.containsKey(id)) {
            throw new RegistryFailureException(id, "TempModifier", String.format("Found duplicate TempModifier entries: %s (%s) %s (%s)", supplier.get().getClass().getName(), id, TEMP_MODIFIERS.get(id).getClass().getName(), id), null);
        }
        TEMP_MODIFIERS.put(id, new TempModifierHolder(supplier));
    }

    public static void flush() {
        TEMP_MODIFIERS.clear();
    }

    public static Optional<TempModifier> getValue(ResourceLocation id) {
        return Optional.ofNullable(TEMP_MODIFIERS.get(id)).map(TempModifierHolder::get);
    }

    public static ResourceLocation getKey(TempModifier modifier) {
        return TEMP_MODIFIERS.getKey(new TempModifierHolder(() -> modifier));
    }

    public static class TempModifierHolder {
        private final Supplier<TempModifier> supplier;
        private final Class<? extends TempModifier> clazz;

        public TempModifierHolder(Supplier<TempModifier> supplier) {
            this.supplier = supplier;
            this.clazz = supplier.get().getClass();
        }

        public TempModifier get() {
            return this.supplier.get();
        }

        public Class<? extends TempModifier> getModifierClass() {
            return this.clazz;
        }

        public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof TempModifier) {
                TempModifier mod = (TempModifier)obj;
                bl = mod.getClass().equals(this.clazz);
            } else {
                TempModifierHolder holder;
                bl = obj instanceof TempModifierHolder && (holder = (TempModifierHolder)obj).getModifierClass().equals(this.clazz);
            }
            return bl;
        }

        public String toString() {
            return this.clazz.getName();
        }
    }
}

